(define (fact n)
  (if (= n 0)
      1
      (* n (fact (- n 1)))))

(define (print-html e)
  (if (list? e)
      (begin (format #t "<~a>" (car e))
	     (print-html-list (cdr e))
	     (format #t "</~a>" (car e)))
      (display e)))

(define (print-html e)
  (if (list? e)
      (begin (print-open-tag (car e))
	     (print-html-list (cdr e))
	     (print-close-tag (car e)))
      (display e)))

(define (print-html-list l)
  (if (null? l)
      #f
      (begin (print-html (car l))
	     (print-html-list (cdr l)))))

(define sample
'(html
 (body
   (h1 "Lisp")
   (table
     (tr (td 1) (td "lisp"))
     (tr (td 2) (td "scheme"))))))
